/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import org.jspecify.annotations.Nullable;

public final class PocketServerComputer
extends ServerComputer {
    private final PocketBrain brain;
    private int oldLightColour = -1;
    private @Nullable ComputerState oldComputerState;
    private Set<ServerPlayer> tracking = Set.of();

    PocketServerComputer(PocketBrain brain, PocketHolder holder, ServerComputer.Properties properties) {
        super(holder.level(), holder.blockPos(), properties.terminalSize((Integer)ConfigSpec.pocketTermWidth.get(), (Integer)ConfigSpec.pocketTermHeight.get()).addComponent(ComputerComponents.POCKET, brain));
        this.brain = brain;
    }

    public PocketBrain getBrain() {
        return this.brain;
    }

    @Override
    protected void tickServer() {
        List<ServerPlayer> added;
        super.tickServer();
        List newTracking = this.getLevel().getChunkSource().chunkMap.getPlayers(new ChunkPos(this.getPosition()), false);
        boolean trackingChanged = this.tracking.size() != newTracking.size() || !this.tracking.containsAll(newTracking);
        ComputerState state = this.getState();
        int light = this.brain.getLight();
        if (this.oldLightColour != light || this.oldComputerState != state) {
            this.oldComputerState = state;
            this.oldLightColour = light;
            ServerNetworking.sendToPlayers(new PocketComputerDataMessage(this, false), newTracking);
        } else if (trackingChanged && !(added = newTracking.stream().filter(x -> !this.tracking.contains(x)).toList()).isEmpty()) {
            ServerNetworking.sendToPlayers(new PocketComputerDataMessage(this, this.brain.holder().isTerminalAlwaysVisible()), added);
        }
        if (trackingChanged) {
            this.tracking = Set.copyOf(newTracking);
        }
    }

    @Override
    protected void onTerminalChanged() {
        PocketHolder.PlayerHolder h;
        ServerPlayer holder;
        super.onTerminalChanged();
        PocketHolder pocketHolder = this.brain.holder();
        ServerPlayer serverPlayer = holder = pocketHolder instanceof PocketHolder.PlayerHolder && (h = (PocketHolder.PlayerHolder)pocketHolder).isValid(this) ? h.entity() : null;
        if (this.brain.holder().isTerminalAlwaysVisible() && !this.tracking.isEmpty()) {
            PocketComputerDataMessage packet = new PocketComputerDataMessage(this, true);
            ServerNetworking.sendToPlayers(packet, this.tracking);
            if (holder != null && !this.tracking.contains(holder)) {
                ServerNetworking.sendToPlayer(packet, holder);
            }
        } else if (holder != null) {
            ServerNetworking.sendToPlayer(new PocketComputerDataMessage(this, true), holder);
        }
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        ServerNetworking.sendToAllPlayers(new PocketComputerDeletedClientMessage(this.getInstanceUUID()), this.getLevel().getServer());
    }
}

